import { formatDistance } from "./bs/_lib/formatDistance.js";
import { formatLong } from "./bs/_lib/formatLong.js";
import { formatRelative } from "./bs/_lib/formatRelative.js";
import { localize } from "./bs/_lib/localize.js";
import { match } from "./bs/_lib/match.js";

/**
 * @category Locales
 * @summary Bosnian locale.
 * @language Bosnian
 * @iso-639-2 bos
 * @author Branislav Lazić [@branislavlazic](https://github.com/branislavlazic)
 */
export const bs = {
  code: "bs",
  formatDistance: formatDistance,
  formatLong: formatLong,
  formatRelative: formatRelative,
  localize: localize,
  match: match,
  options: {
    weekStartsOn: 1 /* Monday */,
    firstWeekContainsDate: 4,
  },
};

// Fallback for modularized imports:
export default bs;
