export function generateMockCrimes(center: { lat: number, lng: number }, count = 20) {
  const crimeTypes = ["ล้วงกระเป๋า", "ชิงทรัพย์", "ทำร้ายร่างกาย"];
  const crimes = [];

  for (let i = 0; i < count; i++) {
    const latOffset = (Math.random() - 0.5) * 0.05;
    const lngOffset = (Math.random() - 0.5) * 0.05;

    crimes.push({
      name: `จุดเสี่ยง #${i + 1}`,
      crime_type: crimeTypes[Math.floor(Math.random() * crimeTypes.length)],
      incident_count: Math.floor(Math.random() * 20) + 1,
      lat: center.lat + latOffset,
      lng: center.lng + lngOffset,
    });
  }

  return crimes;
}
